﻿/****** Object:  StoredProcedure [dbo].[USM_GetUsersWithPermissionForProject]    Script Date: 4/21/2016 1:27:53 PM ******/

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_ReassignHardCallback]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[VX_sp_ReassignHardCallback]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE VX_sp_ReassignHardCallback
@TraceID BIGINT -- this is to link to a BufferTrace execution trace
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
		INSERT INTO TraceLog (TraceId, TraceTime, TraceStep, TraceMessage) VALUES (@TraceId, GETUTCDATE(), 1, 'VX_sp_ReassignHardCallback Enter')

		UPDATE Installation SET InsDateTimeValue = GETUTCDATE()
			WHERE Inssection='CALLBACKS' AND Insident = 'LAST_REASSIGNMENT_JOB_TIME'

		IF OBJECT_ID('tempdb..#ReassignCodesTable') IS NOT NULL
			DROP TABLE #ReassignCodesTable;

		IF OBJECT_ID('tempdb..#ExcludeIntervTable') IS NOT NULL
			DROP TABLE #ExcludeIntervTable;

		DECLARE @LeewayDelay INT;
		SET @LeewayDelay = (SELECT TOP 1 insValue FROM Installation WHERE Inssection='CALLBACKS' AND Insident = 'LEEWAY_PERIOD')
 
		DECLARE @ReassignCode NVARCHAR(MAX);
		SET @ReassignCode = (SELECT TOP 1 insValue FROM Installation WHERE Inssection='CALLBACKS' AND Insident = 'REASSIGN_CODES')

		IF (LEN(LTRIM(@ReassignCode)) = 0 OR @LeewayDelay = 0)
			RETURN;

		DECLARE @ProjectId INT;
		SET @ProjectId =	( SELECT TOP 1 Pages.k_id
							  FROM tblPages AS Pages
							  WHERE Pages.Kind=12000 AND Pages.Name = 'InterviewerProjectId' and ('Voxco_Project_' + Pages.StaticValue = DB_NAME())
		);

		SELECT [Code].Value AS [Code]
		INTO #ReassignCodesTable
		FROM VoxcoSystem.dbo.fn_cte_splitstring(@ReassignCode, ';') Code

		SELECT [Code].Value AS [Interv]
		INTO #ExcludeIntervTable
		FROM VoxcoSystem.dbo.fn_cte_splitstring('***;G01;G02;G03;G04;G05;G06;G07;G08;G09' , ';') Code

		INSERT INTO TraceLog (TraceId, TraceTime, TraceStep, TraceMessage) VALUES (@TraceId, GETUTCDATE(), 2, 'VX_sp_ReassignHardCallback Start Execution CODES=' + @ReassignCode + ' Leeway=' + LTRIM(STR(@LeewayDelay)))

		UPDATE [Respondent] SET ResIntervCall = CASE WHEN (Grp.[Group]) IS NULL THEN '***' ELSE 'G0' + STR(Grp.[Group],1) END /* STR convert to length of 1 */
		--SELECT RES.[ResRespondent], [GRP].[Group]
			FROM Respondent AS RES LEFT JOIN 
				(SELECT StrRespondent AS Respondent, min(Quota.QtGroup) AS [Group]
				FROM Stratum inner join Quota ON StrQuotaID = QtQuotaID /* DO NOT use StrStratum to join */
				WHERE QtGroup <> 0
				GROUP BY StrRespondent) [GRP] ON Res.ResRespondent = Grp.Respondent
			WHERE
				RES.ResCall = 1 /* Is not a fresh */
				AND not exists (SELECT 1 FROM Intweb_ActiveSessions AS ActiveRecords WHERE @ProjectId = [ProjectId] and ActiveRecords.CurrentRecord= ResRespondent) /* Not active in IntWeb */
				AND (RES.rescallbackdate < (DATEADD(MINUTE, -@LeewayDelay, GETUTCDATE())) AND RES.rescallbackdate > 0) /* As callback and pas leeway period */
				AND EXISTS (SELECT 1 FROM #ReassignCodesTable WHERE Code = ResCodeResult) /* Respondent result is in reassignement code list */
				AND NOT EXISTS (SELECT 1 FROM #ExcludeIntervTable WHERE Interv = ResIntervCall) /* Interv list not to be reassigned */

		IF OBJECT_ID('tempdb..#ReassignCodesTable') IS NOT NULL
			DROP TABLE #ReassignCodesTable;

		IF OBJECT_ID('tempdb..#ExcludeIntervTable') IS NOT NULL
			DROP TABLE #ExcludeIntervTable;

	END TRY
	BEGIN CATCH
		IF OBJECT_ID('tempdb..#ReassignCodesTable') IS NOT NULL
			DROP TABLE #ReassignCodesTable;

		IF OBJECT_ID('tempdb..#ExcludeIntervTable') IS NOT NULL
			DROP TABLE #ExcludeIntervTable;

		DECLARE @ErrorMessage NVARCHAR(4000);
		DECLARE @ErrorSeverity INT;

		SELECT 
			@ErrorMessage = ERROR_MESSAGE() + ':' + isnull(ERROR_PROCEDURE(), '??') + '(' + convert(NVARCHAR(20), ERROR_LINE()) + ')',
			@ErrorSeverity = ERROR_SEVERITY();

		INSERT INTO TraceLog (TraceId, TraceTime, TraceStep, TraceMessage) VALUES (@TraceId, GETUTCDATE(), 3, 'VX_sp_ReassignHardCallback Execution Exception - See SQL Server logs for more details')
		EXEC [sys].[xp_logevent] 50001, @ErrorMessage, @ErrorSeverity
	END CATCH;

	INSERT INTO TraceLog (TraceId, TraceTime, TraceStep, TraceMessage) VALUES (@TraceId, GETUTCDATE(), 3, 'VX_sp_ReassignHardCallback Execution Completed')

	SET NOCOUNT OFF
END


    
